<?php

require_once '../model/database.php';
require_once '../model/product_model.php';
require_once 'header.php';

$products = get_all_products($conn);
?>

<h1>Product Information</h1>

<nav>
    <a href="../index.php">Home</a> |
    <a href="manage_vendors.php">Manage Vendors</a> |
    <a href="product_add.php">Add New Product</a>
</nav>

<h2>List of Products</h2>

<table>
<table border='1' cellpadding='5'>
    <thead>
        <tr>
            <th>Product Name</th>
            <th>Details</th>
            <th>Update</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($products as $product): ?>
            <tr>
                <td><?php echo $product['prod_name']; ?></td>
                <td><a href="product_details.php?product_id=<?php echo $product['prod_id']; ?>">Details</a></td>
                <td><a href="product_update.php?product_id=<?php echo $product['prod_id']; ?>">Update</a></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<?php
require_once 'footer.php';
?>